/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.PackFile;
import com.izforge.izpack.UpdateCheck;
import com.izforge.izpack.event.InstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.IUnpacker;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.Unpacker;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.RESyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnpackerBase
implements IUnpacker {
    protected AutomatedInstallData idata;
    protected AbstractUIProgressHandler handler;
    protected UninstallData udata;
    protected VariableSubstitutor vs;
    protected File absolute_installpath;
    private File absolutInstallSource;
    protected LocaleDatabase langpack = null;
    protected boolean result = true;
    protected static HashMap<Object, String> instances = new HashMap();
    protected static boolean interruptDesired = false;
    protected static boolean discardInterrupt = false;
    protected static final String LANG_FILE_NAME = "packsLang.xml";
    public static final String ALIVE = "alive";
    public static final String INTERRUPT = "doInterrupt";
    public static final String INTERRUPTED = "interruppted";
    protected RulesEngine rules;

    public UnpackerBase(AutomatedInstallData automatedInstallData, AbstractUIProgressHandler abstractUIProgressHandler) {
        try {
            String string = "packsLang.xml_" + automatedInstallData.localeISO3;
            this.langpack = new LocaleDatabase(ResourceManager.getInstance().getInputStream(string));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.idata = automatedInstallData;
        this.handler = abstractUIProgressHandler;
        this.vs = new VariableSubstitutor(automatedInstallData.getVariables());
    }

    @Override
    public void setRules(RulesEngine rulesEngine) {
        this.rules = rulesEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getRunningInstances() {
        HashMap<Object, String> hashMap = instances;
        synchronized (hashMap) {
            return (HashMap)instances.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToInstances() {
        HashMap<Object, String> hashMap = instances;
        synchronized (hashMap) {
            instances.put(this, ALIVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromInstances() {
        HashMap<Object, String> hashMap = instances;
        synchronized (hashMap) {
            instances.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setInterruptAll() {
        HashMap<Object, String> hashMap = instances;
        synchronized (hashMap) {
            for (Object object : instances.keySet()) {
                if (!instances.get(object).equals(ALIVE)) continue;
                instances.put(object, INTERRUPT);
            }
            UnpackerBase.setInterruptDesired(true);
        }
    }

    public static boolean interruptAll(long l) {
        long l2 = System.currentTimeMillis();
        if (UnpackerBase.isDiscardInterrupt()) {
            return false;
        }
        UnpackerBase.setInterruptAll();
        while (!UnpackerBase.isInterruptReady()) {
            if (System.currentTimeMillis() - l2 > l) {
                return true;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isInterruptReady() {
        HashMap<Object, String> hashMap = instances;
        synchronized (hashMap) {
            for (Object object : instances.keySet()) {
                if (instances.get(object).equals(INTERRUPTED)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean performInterrupted() {
        HashMap<Object, String> hashMap = instances;
        synchronized (hashMap) {
            String string = instances.get(this);
            if (string != null && (string.equals(INTERRUPT) || string.equals(INTERRUPTED))) {
                instances.put(this, INTERRUPTED);
                this.result = false;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldInterrupt() {
        HashMap<Object, String> hashMap = instances;
        synchronized (hashMap) {
            String string = instances.get(this);
            return string != null && (string.equals(INTERRUPT) || string.equals(INTERRUPTED));
            {
            }
        }
    }

    @Override
    public boolean getResult() {
        return this.result;
    }

    private boolean fileMatchesOnePattern(String string, ArrayList<RE> arrayList) {
        for (RE rE : arrayList) {
            if (!rE.match(string)) continue;
            return true;
        }
        return false;
    }

    private List<RE> preparePatterns(ArrayList<String> arrayList, RECompiler rECompiler) {
        ArrayList<RE> arrayList2 = new ArrayList<RE>();
        for (String string : arrayList) {
            if (string == null || string.length() <= 0) continue;
            File file = new File(string = this.vs.substitute(string, "plain"));
            if (!file.isAbsolute()) {
                string = new File(this.absolute_installpath, string).toString();
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n = -1;
            int n2 = 0;
            block8: while (n2 < string.length()) {
                char c;
                if (n != -1) {
                    c = (char)n;
                    n = -1;
                } else {
                    c = string.charAt(n2++);
                }
                switch (c) {
                    case '/': {
                        stringBuffer.append(File.separator);
                        continue block8;
                    }
                    case '.': 
                    case '\\': {
                        stringBuffer.append("\\");
                        stringBuffer.append(c);
                        continue block8;
                    }
                    case '*': {
                        if (n2 == string.length()) {
                            stringBuffer.append("[^").append(File.separator).append("]*");
                            continue block8;
                        }
                        if ((n = (int)string.charAt(n2++)) == 42) {
                            stringBuffer.append(".*");
                            n = -1;
                            continue block8;
                        }
                        stringBuffer.append("[^").append(File.separator).append("]*");
                        continue block8;
                    }
                }
                stringBuffer.append(c);
            }
            stringBuffer.append('$');
            try {
                arrayList2.add(new RE(rECompiler.compile(stringBuffer.toString())));
            }
            catch (RESyntaxException rESyntaxException) {
                this.handler.emitNotification("internal error: pattern \"" + string + "\" produced invalid RE \"" + file.getPath() + "\"");
            }
        }
        return arrayList2;
    }

    protected void informListeners(List[] listArray, int n, Object object, Object object2, Object object3) throws Exception {
        List list = null;
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                list = listArray[listArray.length - 1];
                break;
            }
            default: {
                list = listArray[0];
            }
        }
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (this.shouldInterrupt()) {
                return;
            }
            InstallerListener installerListener = (InstallerListener)iterator.next();
            switch (n) {
                case 1: {
                    installerListener.beforeFile((File)object, (PackFile)object2);
                    break;
                }
                case 2: {
                    installerListener.afterFile((File)object, (PackFile)object2);
                    break;
                }
                case 3: {
                    installerListener.beforeDir((File)object, (PackFile)object2);
                    break;
                }
                case 4: {
                    installerListener.afterDir((File)object, (PackFile)object2);
                    break;
                }
                case 5: {
                    installerListener.beforePack((Pack)object, (Integer)object2, (AbstractUIProgressHandler)object3);
                    break;
                }
                case 6: {
                    installerListener.afterPack((Pack)object, (Integer)object2, (AbstractUIProgressHandler)object3);
                    break;
                }
                case 7: {
                    installerListener.beforePacks((AutomatedInstallData)object, (Integer)object2, (AbstractUIProgressHandler)object3);
                    break;
                }
                case 8: {
                    installerListener.afterPacks((AutomatedInstallData)object, (AbstractUIProgressHandler)object2);
                }
            }
        }
    }

    protected List[] getCustomActions() {
        int n;
        String[] stringArray = AutomatedInstallData.CUSTOM_ACTION_TYPES;
        List[] listArray = new List[stringArray.length + 1];
        for (n = 0; n < stringArray.length; ++n) {
            listArray[n] = this.idata.customData.get(stringArray[n]);
            if (listArray[n] != null) continue;
            listArray[n] = new ArrayList();
        }
        if (listArray[0].size() > 0) {
            n = listArray.length - 1;
            listArray[n] = new ArrayList();
            for (InstallerListener installerListener : listArray[0]) {
                if (!installerListener.isFileListener()) continue;
                listArray[n].add(installerListener);
            }
        }
        return listArray;
    }

    protected boolean mkDirsWithEnhancement(File file, PackFile packFile, List[] listArray) throws Exception {
        String string = "unknown";
        if (file != null) {
            string = file.getAbsolutePath();
        }
        if (file != null && !file.exists() && file.getParentFile() != null) {
            if (file.getParentFile().exists()) {
                this.informListeners(listArray, 3, file, packFile, null);
            }
            if (!file.mkdir()) {
                this.mkDirsWithEnhancement(file.getParentFile(), packFile, listArray);
                if (!file.mkdir()) {
                    file = null;
                }
            }
            this.informListeners(listArray, 4, file, packFile, null);
        }
        if (file == null) {
            this.handler.emitError("Error creating directories", "Could not create directory\n" + string);
            this.handler.stopAction();
            return false;
        }
        return true;
    }

    public static synchronized boolean isDiscardInterrupt() {
        return discardInterrupt;
    }

    public static synchronized void setDiscardInterrupt(boolean bl) {
        discardInterrupt = bl;
        UnpackerBase.setInterruptDesired(false);
    }

    public static boolean isInterruptDesired() {
        return interruptDesired;
    }

    private static void setInterruptDesired(boolean bl) {
        interruptDesired = bl;
    }

    protected void putUninstaller() throws Exception {
        ZipOutputStream zipOutputStream;
        String string = this.idata.info.getUninstallerCondition();
        if (string != null && string.length() > 0 && !this.rules.isConditionTrue(string)) {
            Debug.log("Uninstaller has a condition (" + string + ") which is not fulfilled.");
            Debug.log("Skipping creation of uninstaller.");
            return;
        }
        InputStream[] inputStreamArray = new InputStream[2];
        inputStreamArray[0] = UnpackerBase.class.getResourceAsStream("/res/IzPack.uninstaller");
        if (inputStreamArray[0] == null) {
            return;
        }
        inputStreamArray[1] = UnpackerBase.class.getResourceAsStream("/res/IzPack.uninstaller-ext");
        String string2 = IoHelper.translatePath(this.idata.info.getUninstallerPath(), this.vs);
        String string3 = string2 + File.separator + this.idata.info.getUninstallerName();
        File file = new File(string2);
        file.mkdirs();
        this.udata.setUninstallerJarFilename(string3);
        this.udata.setUninstallerPath(string2);
        FileOutputStream fileOutputStream = new FileOutputStream(string3);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        this.idata.uninstallOutJar = zipOutputStream = new ZipOutputStream(bufferedOutputStream);
        zipOutputStream.setLevel(9);
        this.udata.addFile(string3, true);
        HashSet<String> hashSet = new HashSet<String>();
        for (InputStream inputStream : inputStreamArray) {
            if (inputStream == null) continue;
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                if (!hashSet.contains(zipEntry.getName())) {
                    hashSet.add(zipEntry.getName());
                    zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
                    int n = zipInputStream.read();
                    while (n != -1) {
                        zipOutputStream.write(n);
                        n = zipInputStream.read();
                    }
                    zipInputStream.closeEntry();
                    zipOutputStream.closeEntry();
                }
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.close();
        }
        if (this.idata.info.isPrivilegedExecutionRequiredUninstaller()) {
            zipOutputStream.putNextEntry(new ZipEntry("exec-admin"));
            zipOutputStream.closeEntry();
        }
        InputStream inputStream = Unpacker.class.getResourceAsStream("/langpacks/" + this.idata.localeISO3 + ".xml");
        zipOutputStream.putNextEntry(new ZipEntry("langpack.xml"));
        int n = inputStream.read();
        while (n != -1) {
            zipOutputStream.write(n);
            n = inputStream.read();
        }
        zipOutputStream.closeEntry();
    }

    protected void handleAdditionalUninstallData(UninstallData uninstallData, List[] listArray) {
        uninstallData.addAdditionalData("__uninstallLibs__", listArray[2]);
        uninstallData.addAdditionalData("uninstallerListeners", listArray[1]);
        uninstallData.addAdditionalData("uninstallerJars", listArray[3]);
    }

    @Override
    public abstract void run();

    protected void performUpdateChecks(ArrayList<UpdateCheck> arrayList) {
        Object object;
        ArrayList<RE> arrayList2 = new ArrayList<RE>();
        ArrayList<RE> arrayList3 = new ArrayList<RE>();
        RECompiler rECompiler = new RECompiler();
        this.absolute_installpath = new File(this.idata.getInstallPath()).getAbsoluteFile();
        for (UpdateCheck stack2 : arrayList) {
            if (stack2.includesList != null) {
                arrayList2.addAll(this.preparePatterns(stack2.includesList, rECompiler));
            }
            if (stack2.excludesList == null) continue;
            arrayList3.addAll(this.preparePatterns(stack2.excludesList, rECompiler));
        }
        if (arrayList2.size() == 0) {
            return;
        }
        TreeSet treeSet = new TreeSet();
        for (String string : this.udata.getInstalledFilesList()) {
            object = new File(string);
            if (!((File)object).isAbsolute()) {
                object = new File(this.absolute_installpath, string);
            }
            treeSet.add(((File)object).getAbsolutePath());
        }
        Stack<File> stack = new Stack<File>();
        ArrayList<File> arrayList4 = new ArrayList<File>();
        try {
            stack.add(this.absolute_installpath);
            while (!stack.empty()) {
                object = (File)stack.pop();
                Object object2 = ((File)object).listFiles();
                if (object2 == null) {
                    throw new IOException(((File)object).getPath() + "is not a directory!");
                }
                for (File file : object2) {
                    String string = file.getPath();
                    if (treeSet.contains(string)) continue;
                    if (this.fileMatchesOnePattern(string, arrayList2) && !this.fileMatchesOnePattern(string, arrayList3)) {
                        arrayList4.add(file);
                    }
                    if (!file.isDirectory() || this.fileMatchesOnePattern(string, arrayList3)) continue;
                    stack.push(file);
                }
            }
        }
        catch (IOException iOException) {
            this.handler.emitError("error while performing update checks", iOException.toString());
        }
        for (Object object2 : arrayList4) {
            if (((File)object2).isDirectory()) continue;
            ((File)object2).delete();
        }
    }

    public void writeInstallationInformation() throws IOException, ClassNotFoundException {
        Closeable closeable;
        Closeable closeable2;
        if (!this.idata.info.isWriteInstallationInformation()) {
            Debug.trace("skip writing installation information");
            return;
        }
        Debug.trace("writing installation information");
        String string = this.idata.getInstallPath();
        ArrayList<Pack> arrayList = new ArrayList<Pack>(this.idata.selectedPacks);
        File file = new File(string + File.separator + ".installationinformation");
        if (!file.exists()) {
            Debug.trace("creating info file" + file.getAbsolutePath());
            file.createNewFile();
        } else {
            Debug.trace("installation information found");
            closeable2 = new FileInputStream(file);
            closeable = new ObjectInputStream((InputStream)closeable2);
            List list = (List)((ObjectInputStream)closeable).readObject();
            for (Object e : list) {
                Pack pack = (Pack)e;
                arrayList.add(pack);
            }
            ((ObjectInputStream)closeable).close();
            ((FileInputStream)closeable2).close();
        }
        closeable2 = new FileOutputStream(file);
        closeable = new ObjectOutputStream((OutputStream)closeable2);
        ((ObjectOutputStream)closeable).writeObject(arrayList);
        ((ObjectOutputStream)closeable).writeObject(this.idata.variables);
        Debug.trace("done.");
        ((ObjectOutputStream)closeable).close();
        ((FileOutputStream)closeable2).close();
    }

    protected File getAbsolutInstallSource() throws Exception {
        if (this.absolutInstallSource == null) {
            URI uRI = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
            if (!"file".equals(uRI.getScheme())) {
                throw new Exception("Unexpected scheme in JAR file URI: " + uRI);
            }
            this.absolutInstallSource = new File(uRI.getSchemeSpecificPart()).getAbsoluteFile();
            if (this.absolutInstallSource.getName().endsWith(".jar")) {
                this.absolutInstallSource = this.absolutInstallSource.getParentFile();
            }
        }
        return this.absolutInstallSource;
    }
}

